'use client';

import Header from '../../../components/Header';
import MobileHeader from '../../../components/MobileHeader';
import Footer from '../../../components/Footer';
import { useEffect, useRef, useState } from 'react';
import { useTranslations } from 'next-intl';
import AnimatedText from '../../../components/AnimatedText';
import AnimatedImage from '../../../components/AnimatedImage';
import AnimatedElement from '../../../components/AnimatedElement';

export default function CharacteristicsPage() {
  const t = useTranslations('CharacteristicsPage');
  const videoRef = useRef<HTMLVideoElement>(null);
  const [isDesktop, setIsDesktop] = useState(false);

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  useEffect(() => {
    const video = videoRef.current;
    if (video) {
      console.log('Characteristics page video element found, attempting to play...');
      video.play().then(() => {
        console.log('Characteristics page video is playing successfully');
      }).catch((error) => {
        console.error('Error playing characteristics page video:', error);
      });
    }
  }, []);

  if (isDesktop) {
    // Desktop Version
    return (
      <div className="min-h-screen bg-[#F5F1F0] font-roboto">
        <Header />
        
        {/* Panorama Section with Video Background */}
        <section className="relative w-full h-[597px] overflow-hidden">
          {/* Background Video */}
          <video 
            ref={videoRef}
            autoPlay
            loop
            muted
            playsInline
            controls={false}
            preload="auto"
            className="absolute inset-0 object-cover w-full h-full"
            style={{
              position: 'absolute',
              top: 0,
              left: 0,
              right: 0,
              bottom: 0,
              width: '100%',
              height: '100%',
              objectFit: 'cover',
              objectPosition: 'center center',
              zIndex: 1
            }}
            onLoadedData={() => console.log('Characteristics page video loaded successfully!')}
            onError={(e) => console.error('Characteristics page video error:', e)}
            onCanPlay={() => console.log('Characteristics page video can play')}
            onPlay={() => console.log('Characteristics page video is playing')}
            onLoadedMetadata={() => {
              console.log('Characteristics page video metadata loaded');
              const video = videoRef.current;
              if (video) {
                console.log('Video dimensions:', video.videoWidth, 'x', video.videoHeight);
                console.log('Container dimensions:', video.clientWidth, 'x', video.clientHeight);
              }
            }}
          >
            <source src="/images/characteristics/378362936631271432.mp4" type="video/mp4" />
            Your browser does not support the video tag.
          </video>
          
          {/* Gradient Overlay */}
          <div 
            className="absolute inset-0 w-full h-full"
            style={{
              position: 'absolute',
              top: 0,
              left: 0,
              right: 0,
              bottom: 0,
              width: '100%',
              height: '100%',
              background: 'linear-gradient(180deg, rgba(0, 0, 0, 0.19) 0%, rgba(0, 0, 0, 0.40) 100%)',
              zIndex: 2,
              pointerEvents: 'none'
            }}
          ></div>
          
          {/* Combined Title and Subtitle Container */}
          <div className="relative z-10 flex flex-col justify-between w-full h-full max-w-[1376px] mx-auto p-8">
            <AnimatedText
              as="h1"
              animation="slideInUp"
              delay={200}
              className="w-full text-white text-center text-[40px] font-light leading-[115%] tracking-[-1.2px] font-roboto"
            >
              {t('hero_title')}
            </AnimatedText>
            <AnimatedText
              as="p"
              animation="slideInUp"
              delay={400}
              className="w-full text-white text-2xl font-light leading-[130%] font-roboto"
            >
              {t('hero_subtitle')}
            </AnimatedText>
          </div>
        </section>

        {/* Characteristics Cards Section */}
        <section className="flex py-[60px] flex-col justify-center items-center gap-10 w-full">
          
          {/* First Card - Image Left, Content Right */}
          <div className="flex w-full px-8 items-center gap-10 justify-center">
            <div className="flex max-w-[1440px] w-full items-center gap-10">
              <AnimatedElement
                animation="slideInLeft"
                delay={200}
                className="flex h-[672px] w-[672px] items-start gap-2 flex-1"
              >
                <video
                  autoPlay
                  loop
                  muted
                  playsInline
                  controls={false}
                  className="w-full h-full object-cover"
                >
                  <source src="/images/characteristics/doc_2025-07-08_01-44-28.mp4" type="video/mp4" />
                </video>
              </AnimatedElement>
              <div className="flex flex-col justify-center items-start gap-8 flex-1">
                
                {/* Proximity to Key Destinations */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={400}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c1_title1')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={500}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto whitespace-pre-line"
                    >
                      {t('c1_text1')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Number of Villas */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={600}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c1_title2')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={700}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c1_text2')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Plot Size */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={800}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c1_title3')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={900}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c1_text3')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Villa Size */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={1000}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c1_title4')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={1100}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c1_text4')}
                    </AnimatedText>
                  </div>
                </div>

              </div>
            </div>
          </div>

          {/* Second Card - Content Left, Image Right */}
          <div className="flex w-full px-8 items-center gap-10 justify-center">
            <div className="flex max-w-[1440px] w-full items-center gap-10">
              <div className="flex flex-col justify-center items-start gap-8 flex-1">
                
                {/* Design & Style */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInLeft"
                    delay={400}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c2_title1')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInLeft"
                      delay={500}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c2_text1')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Construction Materials */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInLeft"
                    delay={600}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c2_title2')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInLeft"
                      delay={700}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c2_text2')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Energy Efficiency */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInLeft"
                    delay={800}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c2_title3')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInLeft"
                      delay={900}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c2_text3')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Roads & Infrastructure */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInLeft"
                    delay={1000}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c2_title4')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInLeft"
                      delay={1100}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c2_text4')}
                    </AnimatedText>
                  </div>
                </div>

              </div>
              <AnimatedElement
                animation="slideInRight"
                delay={200}
                className="flex h-[672px] w-[672px] items-start gap-2 flex-1"
              >
                <video
                  autoPlay
                  loop
                  muted
                  playsInline
                  controls={false}
                  className="w-full h-full object-cover"
                >
                  <source src="/images/characteristics/doc_2025-07-08_01-45-41.mp4" type="video/mp4" />
                </video>
              </AnimatedElement>
            </div>
          </div>

          {/* Third Card - Image Left, Content Right */}
          <div className="flex w-full px-8 items-center gap-10 justify-center">
            <div className="flex max-w-[1440px] w-full items-center gap-10">
              <AnimatedElement
                animation="slideInLeft"
                delay={200}
                className="flex h-[672px] w-[672px] items-start gap-2 flex-1 bg-cover bg-center"
              >
                <div
                  className="w-full h-full bg-cover bg-center"
                  style={{
                    backgroundImage: "url('/images/characteristics/5337ceb9f9663de6f20a92afcf43e51ada788806.jpg')",
                    backgroundColor: 'lightgray'
                  }}
                />
              </AnimatedElement>
              <div className="flex flex-col justify-center items-start gap-8 flex-1">
                
                {/* Security */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={400}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c3_title1')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={500}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c3_text1')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Recreation Facilities */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={600}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c3_title2')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={700}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c3_text2')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Transport */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={800}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c3_title3')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={900}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c3_text3')}
                    </AnimatedText>
                  </div>
                </div>

                {/* Turnkey Homes */}
                <div className="flex flex-col justify-center items-start gap-4 w-full">
                  <AnimatedText
                    as="h3"
                    animation="slideInRight"
                    delay={1000}
                    className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                  >
                    {t('c3_title5')}
                  </AnimatedText>
                  <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                    <AnimatedText
                      as="p"
                      animation="slideInRight"
                      delay={1100}
                      className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                    >
                      {t('c3_text5')}
                    </AnimatedText>
                  </div>
                </div>

              </div>
            </div>
          </div>

        </section>

        <Footer />
      </div>
    );
  } else {
    // Mobile Version
    return (
      <div className="flex w-full flex-col items-start bg-[#F5F1F0] font-roboto">
        {/* Header */}
        <div className="flex py-[5px] pl-3 pr-0 justify-between items-center w-full bg-white">
          <MobileHeader />
        </div>

        {/* Panorama Section */}
        <section className="flex flex-col justify-center items-center gap-6 w-full relative overflow-hidden">
          <div className="flex py-8 px-3 flex-col justify-end items-start gap-6 w-full relative overflow-hidden">
            
            {/* Background Video */}
            <video 
              ref={videoRef}
              autoPlay
              loop
              muted
              playsInline
              controls={false}
              preload="auto"
              className="absolute inset-0 w-full h-full"
              style={{
                position: 'absolute',
                top: 0,
                left: 0,
                right: 0,
                bottom: 0,
                width: '100%',
                height: '100%',
                objectFit: 'cover',
                objectPosition: 'center center',
                zIndex: 1
              }}
            >
              <source src="/images/characteristics/378362936631271432.mp4" type="video/mp4" />
              Your browser does not support the video tag.
            </video>
            
            {/* Gradient Overlay */}
            <div 
              className="absolute inset-0 w-full h-full bg-gradient-to-b from-[rgba(0,0,0,0.19)] to-[rgba(0,0,0,0.40)]"
              style={{ zIndex: 2 }}
            ></div>
            
            <div className="flex h-[782px] max-w-[1376px] flex-col items-start gap-6 w-full relative" style={{ zIndex: 3 }}>
              <div className="flex flex-col justify-between items-start flex-1 w-full">
                <AnimatedText
                  as="h1"
                  animation="slideInUp"
                  delay={200}
                  className="w-full text-white text-center text-[40px] font-light leading-[115%] tracking-[-1.2px] font-roboto"
                >
                  {t('hero_title')}
                </AnimatedText>
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={400}
                  className="w-full text-white text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('hero_subtitle')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </section>

        {/* Characteristics Cards Section */}
        <section className="flex py-[60px] flex-col justify-center items-center gap-10 w-full">
          
          {/* First Card */}
          <div className="flex w-full px-3 flex-col justify-center items-start gap-10">
            <AnimatedElement
              animation="slideInUp"
              delay={300}
              className="flex h-[351px] w-full items-start gap-2"
            >
              <video
                autoPlay
                loop
                muted
                playsInline
                controls={false}
                className="w-full h-full object-cover"
              >
                <source src="/images/characteristics/doc_2025-07-08_01-44-28.mp4" type="video/mp4" />
              </video>
            </AnimatedElement>
            <div className="flex flex-col justify-center items-start gap-8 w-full">
              
              {/* Proximity to Key Destinations */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={400}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c1_title1')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={500}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto whitespace-pre-line"
                  >
                    {t('c1_text1')}
                  </AnimatedText>
                </div>
              </div>

              {/* Number of Villas */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c1_title2')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={700}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c1_text2')}
                  </AnimatedText>
                </div>
              </div>

              {/* Plot Size */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={800}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c1_title3')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={900}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c1_text3')}
                  </AnimatedText>
                </div>
              </div>

              {/* Villa Size */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={1000}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c1_title4')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={1100}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c1_text4')}
                  </AnimatedText>
                </div>
              </div>

            </div>
          </div>

          {/* Second Card */}
          <div className="flex w-full px-3 flex-col justify-center items-start gap-10">
            <AnimatedElement
              animation="slideInUp"
              delay={300}
              className="flex h-[351px] w-full items-start gap-2"
            >
              <video
                autoPlay
                loop
                muted
                playsInline
                controls={false}
                className="w-full h-full object-cover"
              >
                <source src="/images/characteristics/doc_2025-07-08_01-45-41.mp4" type="video/mp4" />
              </video>
            </AnimatedElement>
            <div className="flex flex-col justify-center items-start gap-8 w-full">
              
              {/* Design & Style */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={400}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c2_title1')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={500}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c2_text1')}
                  </AnimatedText>
                </div>
              </div>

              {/* Construction Materials */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c2_title2')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={700}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c2_text2')}
                  </AnimatedText>
                </div>
              </div>

              {/* Energy Efficiency */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={800}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c2_title3')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={900}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c2_text3')}
                  </AnimatedText>
                </div>
              </div>

              {/* Roads & Infrastructure */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={1000}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c2_title4')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={1100}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c2_text4')}
                  </AnimatedText>
                </div>
              </div>

            </div>
          </div>

          {/* Third Card */}
          <div className="flex w-full px-3 flex-col justify-center items-start gap-10">
            <AnimatedElement
              animation="slideInUp"
              delay={300}
              className="flex h-[351px] w-full items-start gap-2 bg-cover bg-center"
            >
              <div
                className="w-full h-full bg-cover bg-center"
                style={{
                  backgroundImage: "url('/images/characteristics/5337ceb9f9663de6f20a92afcf43e51ada788806.jpg')",
                  backgroundColor: 'lightgray'
                }}
              />
            </AnimatedElement>
            <div className="flex flex-col justify-center items-start gap-8 w-full">
              
              {/* Security */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={400}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c3_title1')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={500}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c3_text1')}
                  </AnimatedText>
                </div>
              </div>

              {/* Recreation Facilities */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c3_title2')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={700}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c3_text2')}
                  </AnimatedText>
                </div>
              </div>

              {/* Transport */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={800}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c3_title3')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={900}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c3_text3')}
                  </AnimatedText>
                </div>
              </div>

              {/* Turnkey Homes */}
              <div className="flex flex-col justify-center items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={1000}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('c3_title5')}
                </AnimatedText>
                <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-[rgba(28,28,28,0.20)]">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={1100}
                    className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                  >
                    {t('c3_text5')}
                  </AnimatedText>
                </div>
              </div>

            </div>
          </div>

        </section>

        <Footer />
      </div>
    );
  }
} 